@echo OFF
@rem Argument list:
@rem 1 - application folder name  
@rem 2 - client application name 
@rem 3 - decompressing directory,
@rem 4 - temporary folder
@rem 5 - directory to move old client 
@rem 6 - script name, to remove after completion
@rem 7 - PID du client facultatif
@set delay=500
@set /A MaxTentative=75
@set NumPIDApp=%~7 
 
set FicTrace="%tmp%\Trace4D.txt"
set FicPing="%tmp%\Trace4D_Tmp.txt"

@echo %Date% > %FicTrace%
CALL:Trace "[p0=%~0] [p1=%~1] [p2=%~2] [p3=%~3] [p4=%~4] [p5=%~5] [p6=%~6] [p7=%~7]" 
ver >>%FicTrace%

set /A NoRobocopy=0
robocopy 
IF ERRORLEVEL 9009 (set /A NoRobocopy=1)  
IF %NoRobocopy% == 1 (@echo Execution du script sans l'outil robocopy >> %FicTrace%)
IF %NoRobocopy% == 0 (@echo Execution du script avec l'outil robocopy >> %FicTrace%)

@CALL:Trace "Copy si existant du 4DLink (%~1\Database\EnginedServer.4Dlink)"
@if exist "%~1\Database\EnginedServer.4Dlink" xcopy "%~1\Database\EnginedServer.4Dlink" "%~4\%~3\Database\" /Y /C /R /F >>%FicTrace%

@rem On ne cherche pas la tache si on a pas le numero de PID
IF "%NumPIDApp%" EQU " " GOTO ByeOldClient
IF "%NumPIDApp%" EQU "" GOTO ByeOldClient

@rem recherche du PID du client
@set /A cpt=0
:DelayForQuit4D
call:Trace "Recherche du client grace au PID (%NumPIDApp%)"
tasklist /FI "PID eq %NumPIDApp%" /FO "CSV" /NH >>%FicTrace%
@set /A rc_tasklist=%ERRORLEVEL%
@set /A cpt=%cpt% +1
CALL:Trace "Attente de fermeture du client %cpt%/%MaxTentative% RC:%rc_tasklist%"
@if %cpt% == %MaxTentative% goto StopDelayForQuit4D
IF %rc_tasklist% == 0 (GOTO DelayForQuit4D)

:ByeOldClient
IF EXIST "%~5" @CALL:Trace "Deleted temporary folder (%~5)"
IF EXIST "%~5" @rmdir /S /Q %5 >> %FicTrace%

@rem Tentative de renomage de l'ancien client 
@set /A cpt=0
:StartdoMoveOldClient
@ping 1.1.1.1 -n 1 -w %delay% >>%FicPing%
ren %1 "%~5" 2> $4D_findTmp.txt
set /A rc_ren=%ERRORLEVEL%
CALL:Trace "Tentative de renomage de l'ancien client %cpt%/%MaxTentative% (%1 vers "%~5\") RC:%rc_ren%"
IF %rc_ren% == 0 GOTO:EnddoMoveOldClient
@rem on regarde si le renomage a echoue car un processus empeche le blocage
type $4D_findTmp.txt | find "processus" 
set /A rc_find=%ERRORLEVEL%
@set /A cpt=%cpt% +1
@if %cpt% == %MaxTentative% goto StopdoMoveOldClientRen
IF  %rc_find% == 0 GOTO:StartdoMoveOldClient

@set /A cpt=0
:doMoveOldClient
@ping 1.1.1.1 -n 1 -w %delay% >>%FicPing%
IF %NoRobocopy% == 0 (robocopy %1 "%~5" /MOVE /E /NP >>%FicTrace%)
IF %NoRobocopy% == 1 (move %1 "%~5" >>%FicTrace%)

@set /A cpt=%cpt% +1
CALL:Trace "Tentative de deplacement de l'ancien client %cpt%/%MaxTentative% (%1 vers "%~5\")"
@if %cpt% == %MaxTentative% goto StopdoMoveOldClient

:EnddoMoveOldClient
@if exist $4D_findTmp.txt (del $4D_findTmp.txt)
@if exist %1 goto doMoveOldClient

:MoveNewClient
pushd "%~4"
@set /A cpt=0
:doMoveNewClient
@ping 1.1.1.1 -n 1 -w %delay% >>%FicPing%
IF %NoRobocopy% == 0 (robocopy "%~3" ".\..\%~1" /MOVE /E /NP >>%FicTrace%)
IF %NoRobocopy% == 1 (move "%~3" ".\..\%~1" >>%FicTrace%)

@set /A cpt=%cpt% +1
@CALL:Trace "Tentative de deplacement du nouveau client %cpt%/%MaxTentative% (%1 vers "%~5\")"
@if %cpt%==%MaxTentative% goto StopdoMoveNewClient
@if not exist ".\..\%~1" goto doMoveNewClient
popd

if not exist "%~5\%name%\ClientLocal" goto doLaunchClient
@CALL:Trace "Copy ClientLocal folder (%~5\%name%\ClientLocal\* vers %~1\ClientLocal\)"
xcopy  "%~5\%name%\ClientLocal\*" "%~1\ClientLocal\" /S  /y

:doLaunchClient
@CALL:Trace "Launch new client"
start "Execution du nouveau client" "%~1\%~2"
GOTO:END

:doend
GOTO:EOF

:StopDelayForQuit4D
CALL:Trace "Attente de la fermeture du client echouee !!!" 
tasklist >>%FicTrace%
GOTO:EOF

:StopdoMoveOldClient
CALL:Trace "Deplacement de l'ancien client echoue !!!"
tasklist >>%FicTrace%
CALL:Trace "Redeplacement de l'ancien client"
IF %NoRobocopy% == 0 (robocopy  "%~5" %1 /MOVE /E /NP >>%FicTrace%)
IF %NoRobocopy% == 1 (move "%~5" %1 >>%FicTrace%)

GOTO:END

:StopdoMoveOldClientRen
CALL:Trace "Renommage de l'ancien client echoue !!!"
tasklist >>%FicTrace%
GOTO:END

:StopdoMoveNewClient
CALL:Trace "Deplacement du nouveau client echoue !!!"
popd
CALL:Trace "Redeplacement de l'ancien client"
IF %NoRobocopy% == 0 (robocopy  "%~5" %1 /MOVE /E /NP >>%FicTrace%)
IF %NoRobocopy% == 1 (move "%~5" %1 >>%FicTrace%)

GOTO:END

:Trace
@echo %~1
@echo %~1 >> %FicTrace%
@GOTO:EOF

:RAZ

:End
@CALL:Trace "Deleted temporary folder (%~5)"
@rmdir /S /Q %5 >> %FicTrace%
@CALL:Trace "Deleted temporary folder (%~4)"
@rmdir /S /Q %4 >> %FicTrace%
@GOTO:EOF
